SELECT mf.physical_name AS FICHIER,
       pir.io_pending AS NATURE_ATTENTE,
       pir.io_pending_ms_ticks * @@TIMETICKS / 1000.0 AS ATTENTE_MS
FROM   sys.dm_io_pending_io_requests AS pir
       INNER JOIN sys.dm_io_virtual_file_stats(NULL, NULL) AS vfs
             ON pir.io_handle = vfs.file_handle
       INNER JOIN sys.master_files AS mf
             ON vfs.database_id = mf.database_id
                AND vfs.file_id = mf.file_id
ORDER  BY pir.io_pending, pir.io_pending_ms_ticks DESC;